﻿Imports www.ContentTableAdapters
Public Class ContentBLL
    Public Shared FileUploadMode As Boolean? = Nothing
    Sub New()
        If FileUploadMode Is Nothing Then
            FileUploadMode = True

        End If
    End Sub
    Private Shared _ThumbWidth As Integer = 100
    Public Shared Property ThumbWidth()
        Get
            Return _ThumbWidth
        End Get
        Set(ByVal value)
            _ThumbWidth = value
        End Set
    End Property
#Region "Functions For CotentServices DataTable"
#Region "Select"
    Public Function CountContentServicesByTitle(ByVal Title As String) As Integer
        Try
            Dim Services As New ContentServicesTableAdapter
            If (Services.CountContentServicesByContentServiceTitle(Title)) = 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function CountContentServicesByOwnerSignature(ByVal Ownersignature As String) As Integer
        Try
            Dim Services As New ContentServicesTableAdapter
            If (Services.CountContentServicesByContentServiceOwnerSignature(Ownersignature)) = 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function ContentServices()
        Try
            Dim services As New ContentServicesTableAdapter
            Return services.RetriveContentServices()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServiceByContentServiceID(ByVal ServiceID As Long) As DataTable
        Try
            Dim Service As New ContentServicesTableAdapter
            Return Service.RetriveContentServiceByContentServiceID(ServiceID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServiceByServiceTitle(ByVal ServiceTitle As String) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Return Services.RetriveContentServicesByContentServiceTitle(ServiceTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesByServiceOwnerSignature(ByVal OwnerSignature As String) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Return Services.RetriveContentServicesByContentServiceOwnerSignature(OwnerSignature)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesByServiceUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Return Services.RetriveContentServicesByContentServiceUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesStatus(ByVal Status As Boolean) As DataTable
        Try
            Dim services As New ContentServicesTableAdapter
            Return services.RetriveContentServicesUsingStatus(Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServiceByContentServiceIDStatus(ByVal ServiceID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Service As New ContentServicesTableAdapter
            Return Service.RetriveContentServicesByContentServiceIDUsingStatus(ServiceID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServiceByServiceTitleStatus(ByVal ServiceTitle As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Return Services.RetriveContentServiceByTitleUsingStatus(ServiceTitle, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesByServiceOwnerSignatureStatus(ByVal OwnerSignature As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Return Services.RetriveContentServicesByOwnerSignatureUsingStatus(OwnerSignature, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesByContentServiceTitleANDOwnersignature(ByVal Title As String, ByVal Ownersignature As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Dim a As DataTable = Services.RetriveContentServicesByContentServiceTitleANDOwnersigature(Ownersignature, ThumbWidth, Status)
            Return a
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentServicesByContentServiceTitleANDOwnersignatureStatus(ByVal Title As String, ByVal Ownersignature As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Services As New ContentServicesTableAdapter
            Dim a As DataTable = Services.RetriveContentServicesByContentServiceTitleANDOwnersigature(Ownersignature, Title, Status)
            Return a
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region
#Region "Insert"
    Public Function InsertNewService(ByVal Title As String, ByVal OwnerSignature As String, ByVal Status As Boolean, ByVal CustomOrder As Short, ByVal UserID As Long?) As Integer
        Try
            Dim Service As New ContentServicesTableAdapter
            If (Service.CountContentServicesByContentServiceTitle(Title) = 0) Then
                Dim InsertedRow As Long = Service.RegisterNewContentService(Title, OwnerSignature, Status, CustomOrder, If(UserID = 0, Nothing, UserID))
                If (InsertedRow > 999) Then
                    Return 1 'Insert successfully Done
                Else
                    Return -1 'Insert Faild
                End If
            Else
                Return -2  'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try

    End Function
#End Region
#Region "Update"
    Public Function UpdateContentService(ByVal ContentServiceID As Long, ByVal Title As String, ByVal OwnerSignature As String, ByVal Status As Short, ByVal Customorder As Short, ByVal UserID As Long) As Integer
        Try
            Dim Service As New ContentServicesTableAdapter
            If (Service.CountContentServiceByTitleANDNOTContentServiceID(Title, ContentServiceID) = 0) Then
                If (Service.ReviseContentService(Title, OwnerSignature, Status, Customorder, If(UserID = 0, Nothing, UserID), ContentServiceID)) = 1 Then
                    Return 1 'Update Done
                Else
                    Return -1 ' Update Faild
                End If
            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function

#End Region
#Region "Delete"
    Public Function DeleteContentServiceByContentServiceID(ByVal ContentServiceID As Long) As Integer
        Try
            Dim service As New ContentServicesTableAdapter
            If (service.RemoveContentServiceByContentServiceID(ContentServiceID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentServicesByTitle(ByVal Title As String) As Integer
        Try
            Dim service As New ContentServicesTableAdapter
            If (service.RemoveContentServiceByContentServiceTitle(Title)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentServicesByOwnerSignature(ByVal OwnerSignature As String) As Integer
        Try
            Dim service As New ContentServicesTableAdapter
            If (service.RemoveContentServiceByContentServiceOwnerSignature(OwnerSignature)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentServicesByUserID(ByVal UserID As String) As Integer
        Try
            Dim service As New ContentServicesTableAdapter
            If (service.RemoveContentServiceByContentServiceUserID(UserID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#End Region

#Region "Functions For CotentCategories DataTable"
#Region "Select"
    Public Function ContentCategoriesByServiceTitleAndOwnersignature(ByVal Title As String, ByVal OwnerSignature As String) As DataTable
        Try
            Dim category As New ContentCategoriesTableAdapter
            Return category.RetriveContentCategoriesByOwnerSignatureAndTitle(OwnerSignature, Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByParentID(ByVal ParentID As Long) As DataTable
        Try
            Dim category As New ContentCategoriesTableAdapter
            Return category.RetriveContentCategoriesByContentCategoryParentID(ParentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function

    Public Function ContentCategories()
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategories()

        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoriesStatus(ByVal Status As Boolean) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriesUsingStatus(Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByContentCategoryID(ByVal ContentCategoryID As Long) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoryByContentCategoryID(ContentCategoryID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByContentServiceID(ByVal ContentServiceID As Long) As DataTable
        Try
            Dim category As New ContentCategoriesTableAdapter
            Return category.RetriveContentCategoriesByContentServiceID(ContentServiceID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByContentServiceIDStatus(ByVal ContentServiceID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim category As New ContentCategoriesTableAdapter
            Return category.RetriveContentCategoriesByContentServiceIDUsingStatus(ContentServiceID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByContentCategoryTitle(ByVal Title As String) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoryByContentCategoryTitle(Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriesByContentCategoryUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoryByUserIDStatus(ByVal UserID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriseByUserIDUsingStatus(UserID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoriesByContentServiceTitle(ByVal ContentServiceTitle As String) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriesByContentServiceTitle(ContentServiceTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoriesByContentServiceOwnerSignature(ByVal OwnerSignature As String) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriesByContentServiceOwnerSignature(OwnerSignature)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentCategoriesByContentServiceTitleStatus(ByVal ContentServiceTitle As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Return Category.RetriveContentCategoriesByContentServiceTitleUsingStatus(ContentServiceTitle, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region
#Region "Insert"
    Public Function InsertNewContentCategory(ByVal ContentServiceID As Long, ByVal ParentID As Long?, ByVal Title As String, ByVal URL As String, ByVal VisitCounter As Long, ByVal Status As Boolean, ByVal Customorder As Short, ByVal UserID As Long?) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If ParentID = 0 Then
                If (Category.CountContentCategoryByContentNameANDParentIDisNULL(Title, ContentServiceID)) = 0 Then
                    Dim RowInserted As Long = Category.RegisterNewContentCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID))
                    If RowInserted > 999 Then
                        Return 1  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            Else
                If (Category.CountContentCategoryByContentCategoryTitleANDParentID(Title, ParentID)) = 0 Then
                    Dim RowInserted As Long = Category.RegisterNewContentCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID))
                    If RowInserted > 999 Then
                        Return 1  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            End If

        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function InsertNewContentCategoryReturnScopeIdentity(ByVal ContentServiceID As Long, ByVal ParentID As Long?, ByVal Title As String, ByVal URL As String, ByVal VisitCounter As Long, ByVal Status As Boolean, ByVal Customorder As Short, ByVal UserID As Long?) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If ParentID = 0 Then
                If (Category.CountContentCategoryByContentNameANDParentIDisNULL(Title, ContentServiceID)) = 0 Then
                    Dim RowInserted As Long = Category.RegisterNewContentCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID))
                    If RowInserted > 999 Then
                        Return RowInserted  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            Else
                If (Category.CountContentCategoryByContentCategoryTitleANDParentID(Title, ParentID)) = 0 Then
                    Dim RowInserted As Long = Category.RegisterNewContentCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID))
                    If RowInserted > 999 Then
                        Return RowInserted  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            End If

        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#Region "Update"
    '

    '

    Public Function UpdateContentCategory(ByVal ContentCategoryID As Long, ByVal ContentServiceID As Long, ByVal ParentID As Long?, ByVal Title As String, ByVal URL As String, ByVal VisitCounter As Long, ByVal Status As Boolean, ByVal Customorder As Short, ByVal UserID As Long?) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If ParentID = 0 Then
                If (Category.CountC(Title, ContentCategoryID)) = 0 Then
                    Dim RowInserted As Long = Category.ReviseCollectionCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID), ContentCategoryID)
                    If RowInserted = 1 Then
                        Return RowInserted  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            Else
                If (Category.CountContentCategoryByTitleANDNOTContentCategoryID(Title, ContentCategoryID, ParentID)) = 0 Then
                    Dim RowInserted As Long = Category.ReviseCollectionCategory(ContentServiceID, If(ParentID = 0, Nothing, ParentID), Title, URL, VisitCounter, Status, Customorder, If(UserID = 0, Nothing, UserID), ContentCategoryID)
                    If RowInserted = 1 Then
                        Return RowInserted  'Insert Done
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Return -2 'Dublicate Name
                End If
            End If

        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateCategoryStatus(ByVal ContentCategoryID As Long, ByVal Status As Boolean) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            Dim Result As Integer = Category.ReviseContentCategoryStatus(Status, ContentCategoryID)
            If Result = 1 Then
                Return 1 'Update Done
            Else
                Return -1 'Update Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#Region "Delete"
    Public Function DeleteContentCategoryByContentCategoryID(ByVal ContentCategoryID As Long) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter

            Dim TableCategory As Content.ContentCategoriesDataTable = ContentCategoryByParentID(ContentCategoryID)
            For Each Row As Content.ContentCategoriesRow In TableCategory.Rows
                DeleteContentCategoryByContentCategoryID(Row.ContentCategoryID)
            Next
            Category.RemoveContentCategoryByContentCategoryID(ContentCategoryID)
            Return 1 'Delete Done
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentCategoryByContentTitle(ByVal ContentTitle As String) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If (Category.RemoveContentCategoryByContentCategoryTitle(ContentTitle)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentCategoryByContentUserID(ByVal ContentUserID As Long) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If (Category.RemoveContentCategoriesByContentCategoryUserID(ContentUserID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentCategoryByContentServiceID(ByVal ServiceID As Long) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If (Category.RemoveContentCategoriesByContentServiceID(ServiceID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentCategoryByContentServiceTitle(ByVal ServiceTitle As String) As Integer
        Try
            Dim Category As New ContentCategoriesTableAdapter
            If (Category.RemoveColectionCategoriesByCollectionServiceTitle(ServiceTitle)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#End Region

#Region "Functions For Contents DataTable"
#Region "Select"
#Region "Search"
    Public Function ContentsSearchByTitle(ByVal Title As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsSearchByTitle(Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsSearchByKeyword(ByVal Keyword As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentSearchByKeyword(Keyword, Keyword)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsSearchByCreationDate(ByVal DateOne As Date, ByVal DateTwo As Date) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentSearchByCreationDateBetween(DateOne, DateTwo)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsSearchByPublishDate(ByVal DateOne As Date, ByVal DateTwo As Date) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentSearchByPublishDateBetween(DateOne, DateTwo)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsSearchByArchiveDate(ByVal DateOne As Date, ByVal DateTwo As Date) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentSearchByArchiveDateBetween(DateOne, DateTwo)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region

    Public Function Contents()
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContents()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsStatus(ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsUsingStatus(Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentID(ByVal ContentID As Long) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentID(ContentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentIDStatus(ByVal ContentID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentIDUsingStatus(ContentID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function Contentstop4ByTitleAndOwnersignature(ByVal Title As String, ByVal Ownersignature As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveTop4ContentsByTitleAndOwnersignature(Date.Now, Ownersignature, Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentCategoryID(ByVal CategoryID As Long) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentCategoryID(CategoryID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentCategoryIDStatus(ByVal CategoryID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentCategoryIDUsingStatus(CategoryID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentTitle(ByVal Title As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentTitle(Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentOwnersihnatureANDArchived(ByVal OwnerSignature As String, ByVal Archived As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByOwnersignatureAndArchived(Archived, OwnerSignature)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentTitleStatus(ByVal Title As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentsTitleUsingStatus(Title, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentUserIDStatus(ByVal UserID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByUserIDUsingStatus(UserID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentServiceTitle(ByVal ServiceTitle As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentServiceTitle(ServiceTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentServiceTitleStatus(ByVal ServiceTitle As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentServiceTitleUsingStatus(Status, ServiceTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByArchive(ByVal Archive As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByArchived(Archive)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsByContentServiceTitleANDOwnersignature(ByVal Ownersignature As String, ByVal Title As String, ByVal archived As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByContentServiceTitleANDOwnersignature(archived, Date.Now, Ownersignature, Title)
        Catch ex As Exception
            Return Nothing
        End Try
        ''
    End Function
    Public Function ContentsByContentServiceTitleANDOwnersignatureANDCategoryID(ByVal Ownersignature As String, ByVal Title As String, ByVal CategoryID As Long, ByVal archived As Boolean) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveContentsByTitleAndPublishDateByCategoryID(archived, CategoryID, Date.Now, Ownersignature, Title)
        Catch ex As Exception
            Return Nothing
        End Try
        ''
    End Function
    Public Function ContentsTop3ByContentServiceTitleANDOwnersignature(ByVal Ownersignature As String, ByVal Title As String) As DataTable
        Try
            Dim Content As New ContentsTableAdapter
            Return Content.RetriveTop3ContentSByServiceTitleAndOwnerSignatute(Date.Now, Ownersignature, Title)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region
#Region "Insert"
    Public Function InsertNewContentReturnScopeIdentity(ByVal ContentCategoryID As Long, ByVal Title As String, ByVal Detail As String, ByVal CreationDate As Date?, ByVal PublishDate As Date?, ByVal ArchiveDate As Date?, ByVal CustomOrder As Short, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal Archive As Boolean, ByVal Status As Boolean) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.CountContentsByTitleANDCategoryID(Title, ContentCategoryID)) = 0 Then
                Dim RowInserted As Long = Content.RegisterNewContent(ContentCategoryID, Title, Detail, CreationDate, PublishDate, ArchiveDate, CustomOrder, VisitCounter, If(UserID = 0, Nothing, UserID), Archive, Status)
                If RowInserted > 999 Then
                    Return RowInserted  'Insert Done
                Else
                    Return -1 'Insert Faild
                End If
            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function InsertNewContent(ByVal ContentCategoryID As Long, ByVal Title As String, ByVal Detail As String, ByVal CreationDate As Date?, ByVal PublishDate As Date?, ByVal ArchiveDate As Date?, ByVal CustomOrder As Short, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal Archive As Boolean, ByVal Status As Boolean) As Integer
        Try
            Dim Nowdate As Date = CreationDate
            Dim UniversalDate As Date = Nowdate.ToUniversalTime()
            Dim iranDate As Date = UniversalDate.AddMinutes(210)

            Dim Content As New ContentsTableAdapter
            If (Content.CountContentsByTitleANDCategoryID(Title, ContentCategoryID)) = 0 Then
                Dim RowInserted As Long = Content.RegisterNewContent(ContentCategoryID, Title, Detail, iranDate, PublishDate, ArchiveDate, CustomOrder, VisitCounter, If(UserID = 0, Nothing, UserID), Archive, Status)
                If RowInserted > 999 Then
                    Return 1 'Insert Done
                Else
                    Return -1 'Insert Faild
                End If
            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#Region "Update"
    Public Function UpdateContentsStatus(ByVal ContentID As Long, ByVal Status As Boolean) As Integer
        Try
            Dim Category As New ContentsTableAdapter
            Dim Result As Integer = Category.ReviseContentStatus(Status, ContentID)
            If Result = 1 Then
                Return 1 'Update Done
            Else
                Return -1 'Update Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateContentTitleByContentCategoryID(ByVal ContentCategoryID As Long, ByVal Title As String) As Integer
        Try
            Dim Category As New ContentsTableAdapter
            Dim Result As Integer = Category.ReviseContentCategoryByContentCategoryID(Title, ContentCategoryID)
            If Result = 1 Then
                Return 1 'Update Done
            Else
                Return -1 'Update Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateContent(ByVal ContentID As Long, ByVal ContentCategoryID As Long, ByVal Title As String, ByVal Detail As String, ByVal CreationDate As Date?, ByVal PublishDate As Date?, ByVal ArchiveDate As Date?, ByVal CustomOrder As Short, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal Archive As Boolean, ByVal Status As Boolean) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.CountContentByTitleANDCategoryIDANDNOTContentID(ContentCategoryID, Title, ContentID)) = 0 Then
                If (Content.ReviseContent(ContentCategoryID, Title, Detail, CreationDate, PublishDate, ArchiveDate, CustomOrder, VisitCounter, If(UserID = 0, Nothing, UserID), Archive, Status, ContentID)) = 1 Then
                    Return 1 'Update Done
                Else
                    Return -1 'Update Faild
                End If
            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateArchive(ByVal Archive As Boolean, ByVal ContentID As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.ReviseArchive(Archive, ContentID)) = 1 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try

    End Function
#End Region
#Region "Delete"
    Public Function DeleteContentByContentID(ByVal ContentID As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.RemoveContentByContentID(ContentID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 ' Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentByContentCaregoryID(ByVal ContentCategoryID As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.RemoveContentsByContentCategoryID(ContentCategoryID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 ' Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentByContentUserID(ByVal ContentUserID As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.RemoveContentsByContentUserID(ContentUserID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 ' Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentByContentServiceTitle(ByVal ContentServiceTitle As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.RemoveContentsByContentServiceTitle(ContentServiceTitle)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 ' Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteContentByContentTitle(ByVal ContentTitle As String) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            If (Content.RemoveContentsByTitle(ContentTitle)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 ' Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
    Public Function CountContentsByContentCategoryID(ByVal ContentCategoryID As Long) As Integer
        Try
            Dim Content As New ContentsTableAdapter
            Dim Count As Integer = Content.CountContentsByContentCategoryID(ContentCategoryID)
            Return Count
        Catch ex As Exception
            Return -1000
        End Try

    End Function
#End Region

#Region "Functions For ContentAttachmentANDFiles DataTabe"
#Region "Select"
    Public Function ContentAttachmentsByContentIDStatusIsDefult(ByVal ContentID As Long) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentsByContentIDAndIsDefaultTRUE(ContentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsByContentIDAndIsDefaultTrue(ByVal ContentID As Long) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentsByContentIDAndIsDefaultTRUE(ContentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function MaxContentAttachmentIDByServiceTitleANDOwnerSignature(ByVal Title As String, ByVal Ownersignature As String, ByVal status As Boolean) As Long
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Dim MAX As Long = Attach.RetriveMAXContentAttachmentIDByContentServiceTitleANDOwnersignature(status, Ownersignature, Title)
            Return MAX
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function CountAttachmentByContentID(ByVal ContentID As Long) As Long
        Dim Attach As New ContentAttachmentsTableAdapter
        Dim Count As Long = Attach.CountContentAttachmentByContentID(ContentID)
        Return Count
    End Function
    Public Function ContentAttachments()
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachments()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsByContentAttachmentID(ByVal ContentAtatchmentID As Long) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentsAttachmentByContentAttachmentID(ContentAtatchmentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsByContentID(ByVal ContentID As Long) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentsByContentID(ContentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsByContentIDTop1(ByVal ContentID As Long) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentByContentIDTOP1(ContentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsByContentIDStatus(ByVal ContentID As Long, ByVal Status As Boolean) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentByContentIDUsingStatus(ContentID, Status)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsBycontentTitle(ByVal contentTitle As String) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentsByContentsTitle(contentTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentsFilesByContentAttachmentID(ByVal ContentAttachmentID As Long) As DataTable
        Try
            Dim attch As New FilesTableAdapter
            Return attch.RetriveFilesByContentAttachmentID(ContentAttachmentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function ContentAttachmentsBycontentTitleStatus(ByVal contentTitle As String, ByVal Status As Boolean) As DataTable
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Return Attach.RetriveContentAttachmentByContentsTitleUsingStatus(Status, contentTitle)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function FilesByFileID(ByVal ContentAttachmentID As Long) As DataTable
        Try
            Dim Attach As New FilesTableAdapter
            Return Attach.RetriveFilesByContentAttachmentID(ContentAttachmentID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region
#Region "Insert"
    Public Function AddNewFileAttachmentDataBaseModeReturnScopeIdentity(ByVal Title As String, ByVal Description As String, ByVal ContentID As Long, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal FileContent As Byte(), ByVal FileFormat As String, ByVal IsDefault As Boolean?) As Integer
        Try
            Dim Attach As New ContentAttachments2TableAdapter
            Dim AttachFile As New FilesTableAdapter
            If (Attach.CountContentAttachmentByContentIDANDContentAttachmentTitle(Title, ContentID)) = 0 Then
                If IsDefault = True Then
                    Attach.ReviseAllIsDefalutTrueToFalse(False, ContentID)
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, Nothing, True, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Dim InsertFile As Long = AttachFile.RegisterNewFile(InsertRow, FileContent, FileFormat)
                        If InsertFile > 999 Then
                            Return 1 'InsertDone
                        Else
                            Return -1 'Insert Faild

                        End If
                    Else
                        Return -1  'Insert Faild
                    End If
                Else
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, Nothing, False, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Dim InsertFile As Long = AttachFile.RegisterNewFile(InsertRow, FileContent, FileFormat)
                        If InsertFile > 999 Then
                            Return 1 'InsertDone
                        Else
                            Return -1 'Insert Faild

                        End If
                    Else
                        Return -1  'Insert Faild
                    End If
                End If
            Else
                Return -2  'DublicateName

            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function AddNewFileAttachmentDataBaseMode(ByVal Title As String, ByVal Description As String, ByVal ContentID As Long, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal FileContent As Byte(), ByVal FileFormat As String, ByVal IsDefault As Boolean?) As Integer
        Try
            Dim Attach As New ContentAttachments2TableAdapter
            Dim AttachFile As New FilesTableAdapter
            If (Attach.CountContentAttachmentByContentIDANDContentAttachmentTitle(Title, ContentID)) = 0 Then
                If IsDefault = True Then
                    Dim result As Integer = Attach.ReviseAllIsDefalutTrueToFalse(False, ContentID)
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, Nothing, True, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Dim InsertFile As Long = AttachFile.RegisterNewFile(InsertRow, FileContent, FileFormat)
                        If InsertFile > 999 Then
                            Return 1 'InsertDone
                        Else
                            Return -1 'Insert Faild

                        End If
                    Else
                        Return -1  'Insert Faild
                    End If
                Else
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, Nothing, False, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Dim InsertFile As Long = AttachFile.RegisterNewFile(InsertRow, FileContent, FileFormat)
                        If InsertFile > 999 Then
                            Return 1 'InsertDone
                        Else
                            Return -1 'Insert Faild

                        End If
                    Else
                        Return -1  'Insert Faild
                    End If
                End If

            Else
                Return -2  'DublicateName
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function AddNewFileAttachmentFileMode(ByVal Title As String, ByVal Description As String, ByVal ContentID As Long, ByVal AttachmentFileURL As String, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal IsDefault As Boolean?) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            Dim AttachFile As New FilesTableAdapter
            If (Attach.CountContentAttachmentByContentIDANDContentAttachmentTitle(Title, ContentID)) = 0 Then
                If IsDefault = True Then
                    Attach.ReviseAllIsDefalutTrueToFalse(False, ContentID)
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, AttachmentFileURL, IsDefault, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Return 1 'InsertDone
                    Else
                        Return -1 'Insert Faild
                    End If
                Else
                    Dim InsertRow As Long = Attach.RegisterNewContentAttachment(Title, Description, ContentID, AttachmentFileURL, IsDefault, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                    If InsertRow > 999 Then
                        Return 1 'InsertDone
                    Else
                        Return -1 'Insert Faild
                    End If
                End If
            Else
                Return -2  'DublicateName
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#Region "Update"
    Public Function UpdateAttachment(ByVal ContentAttachmentID As Long, ByVal Title As String, ByVal Description As String, ByVal ContentID As Long, ByVal AttachmentFileURL As String, ByVal VisitCounter As Long, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal IsDefault As Boolean?) As Integer
        Try
            Dim Attach As New ContentAttachments2TableAdapter
            If (Attach.CountContentAttachmentByTitleANDContentIDANDNOTContentAttachmentID(Title, ContentID, ContentAttachmentID)) = 0 Then
                If IsDefault = True Then
                    Attach.ReviseAllIsDefalutTrueToFalse(False, ContentID)
                    If (Attach.ReviseContentAttachment(Title, Description, ContentID, AttachmentFileURL, True, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status, ContentAttachmentID)) = 1 Then
                        Return 1 'Update Done
                    Else
                        Return -1 'UpdateFaild
                    End If
                Else
                    If (Attach.ReviseContentAttachment(Title, Description, ContentID, AttachmentFileURL, False, VisitCounter, If(UserID = 0, Nothing, UserID), CustomOrder, Status, ContentAttachmentID)) = 1 Then
                        Return 1 'Update Done
                    Else
                        Return -1 'UpdateFaild
                    End If
                End If


            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateContentAttachmentStatus(ByVal Status As Boolean, ByVal AttachmentID As Long) As Integer
        Try
            Dim attach As New ContentAttachments2TableAdapter
            Dim Result As Integer = attach.ReviseContentAttachmentStatus(Status, AttachmentID)
            If Result = 1 Then
                Return 1
            ElseIf Result <> 1 Then
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateFile(ByVal ContentAttachmentID As Long, ByVal FileContent As Byte(), ByVal FileFormat As String) As Integer
        Try
            Dim Attach As New FilesTableAdapter
            If (Attach.ReviseFile(ContentAttachmentID, FileContent, FileFormat)) = 1 Then
                Return 1  'Update Done
            Else
                Return -1  'Dublicate Name
            End If
        Catch ex As Exception
        End Try
    End Function
#End Region
#Region "Delete"
    Public Function DeleteContentAttachmentByContentIDAndIsDefaultTrue(ByVal ContentID As Long) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            If (Attach.DeleteContentAttachmentByContentIDAndIsDefaultTRUE(ContentID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteAttachmentByContentAttachmentID(ByVal ContentAttachmentID As Long) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            If (Attach.RemoveContentAttachmentByContentAttachmentID(ContentAttachmentID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteAttachmentByContentID(ByVal ContentID As Long) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            If (Attach.RemoveContentAttachmentByContentID(ContentID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteAttachmentByUserID(ByVal UserID As Long) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            If (Attach.RemoveContentsbyUserID(UserID)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteAttachmentByTitle(ByVal Title As String) As Integer
        Try
            Dim Attach As New ContentAttachmentsTableAdapter
            If (Attach.RemoveContentAttachmentByTitle(Title)) = 1 Then
                Return 1 'Delete Done
            Else
                Return -1 'Delete Faild
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
#End Region
#End Region
End Class

