﻿Imports www.LinksDALTableAdapters
Public Class LinksBLL
    'Functions For LinkServices DataTable

    Public Function LinkCategoryByName(ByVal LinkName As String) As LinksDAL.LinksDataTable
        Try
            'LinkCategoriesByLinkCategoryName
            Dim Link As New LinksTableAdapter()
            Return Link.LinkCategoriesByLinkCategoryName(LinkName)
        Catch ex As Exception

        End Try
    End Function

    Public Function LinkServices() As LinksDAL.LinkServicesDataTable
        Try
            Dim Link As New LinkServicesTableAdapter()
            Return Link.RetrieveLinkServices()
        Catch ex As Exception
            Dim BlankTable As New LinksDAL.LinkServicesDataTable()
            Return BlankTable
        End Try
    End Function
    Public Sub New()
        Dim LinkService As New LinkServicesTableAdapter()
        Dim CountService As Integer = LinkService.CountLinkServices()
        If CountService = 0 Then
            LinkService.RegisterNewLinkServices("سرویس پیوندهای فارسی", "link", Nothing, Nothing, True)
        End If
    End Sub

    Public Function LinkServiceByLinkServiceID(ByVal LinkServiceID As Long) As DataTable
        Try
            Dim Link As New LinkServicesTableAdapter()
            Return Link.RetrieveLinkServiceByLinkServiceID(LinkServiceID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkservicesByServiceName(ByVal ServiceName As String) As DataTable
        Try
            Dim Link As New LinkServicesTableAdapter()
            Return Link.RetireveLinkServicesByServiceName(ServiceName)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkCategiriesisNull() As DataTable
        Try
            Dim Links As New LinkCategoriesTableAdapter()
            Return Links.RetriveLinksCategoryWhereParentIDisNULL()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinksServicesByOwnerSignature(ByVal OwnerSignature As String) As DataTable
        Try
            Dim Link As New LinkServicesTableAdapter()
            Return Link.RetireveLinkServicesByOwnerSignature(OwnerSignature)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinksServicesByUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Link As New LinkServicesTableAdapter()
            Return Link.RetireveLinkServicesByUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function AddNewLinkService(ByVal ServiceName As String, ByVal OwnerSignature As String, ByVal UserID As Long?, ByVal Customorder As Short, ByVal Status As Boolean) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()
            If Link.CountLinkServiceByServiceName(ServiceName) = 0 Then
                Dim InsertID As Long = Link.RegisterNewLinkServices(ServiceName, OwnerSignature, If(UserID = 0, Nothing, UserID), Customorder, Status)
                If InsertID > 999 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinkServiceByLinkServiceID(ByVal LinkServiceID As Long) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()
            If Link.CountLinkServicesByLinkServiceID(LinkServiceID) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkServiceByLinkServiceID(LinkServiceID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinkServicesByServiceName(ByVal ServiceName As String) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()
            If Link.CountLinkServiceByServiceName(ServiceName) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkServiceByServiceName(ServiceName)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinServicesByUserID(ByVal UserID As Long) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()
            If Link.CountLinkServicesByUserID(UserID) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkServiceByUserID(UserID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinkServicesByOwnerSignature(ByVal OwnerSignature As String) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()
            If Link.CountLinkServicesByOwnerSignature(OwnerSignature) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkServiceByOwnerSignature(OwnerSignature)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkServiceByLinkServiceID(ByVal ServiceName As String, ByVal OwnerSigatate As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal LinkServiceID As Long) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()

            If Link.CountLinkServicesByLinkServiceID(LinkServiceID) <> 0 Then
                If Link.CountLinkServiceByServiceName(ServiceName) = 0 Then
                    Dim Update As Long = Link.ReviseLinkServiceByLinkServiceID(ServiceName, OwnerSigatate, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkServiceID)
                    If Update <> 0 Then
                        Return 1
                    Else
                        Return -1
                    End If

                End If
                Return -2  'The Service Name is Dublicate
            End If
            Return -3  'there is no record with this ID
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkServiceByLinkServiceIDwithoutdublicatecheak(ByVal ServiceName As String, ByVal OwnerSigatate As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal LinkServiceID As Long) As Integer
        Try
            Dim Link As New LinkServicesTableAdapter()

            If Link.CountLinkServicesByLinkServiceID(LinkServiceID) <> 0 Then
                Dim Update As Long = Link.ReviseLinkServiceByLinkServiceID(ServiceName, OwnerSigatate, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkServiceID)
                If Update <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
                Return -3  'there is no record with this ID
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    'Functions For LinkCategories DataTable

    Public Function LinkCaregories() As DataTable
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetrieveLinkCategories()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkCategoriesByParentID(ByVal ParetID As Long)
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetriveLinkCategoriesByParentID(ParetID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkCategoriesByServiceID(ByVal ServiceID As Long) As DataTable
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetrieveLinkCategoriesByLinkServiceID(ServiceID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function BindDropDown(ByVal ServiceID As Long) As LinksDAL.LinkCategoriesDataTable
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetrieveLinkCategoriesByLinkServiceID(ServiceID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkCategoryByLinkCategoryID(ByVal LinkCategoryID As Long) As DataTable
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetrieveCategoryByCategoryID(LinkCategoryID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinksByLinkID(ByVal LinkID As Long) As DataTable
        Try
            Dim Link As New LinksTableAdapter()
            Return Link.RetrieveLinksByLinkID(LinkID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinkCategoriesByUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Return Link.RetrieveLinkCategoriesByUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function

    Public Function AddNewLinkCategory(ByVal ParentID As Long?, ByVal LinkServiceID As Long, ByVal Title As String, ByVal Description As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Dim ResultCount As Integer = counterLinkCategoriesByParentIDandTitle(Title, ParentID)
            If ResultCount = 1 Then
                Dim Insert As Long = Link.RegisterNewLinkCategory(If(ParentID = 0, Nothing, ParentID), LinkServiceID, Title, Description, If(UserID = 0, Nothing, UserID), CustomOrder, Status)
                If Insert > 999 Then
                    Return 1
                Else
                    Return -1
                End If
            End If
            Return -2 'The Title is Dublicate
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function CountLinkcategoriesWithTitle(ByVal RegisterTitle As String) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            Dim Result As Long = Link.CountLinkCategoriesByTitle(RegisterTitle)
            Return Result
        Catch ex As Exception
            Return -1000
        End Try

    End Function
    Public Function DeleteLinkCategoriesByUserID(ByVal UserID As Long) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            If Link.CountLinkCategoriesByUserID(UserID) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkCategoryByUserID(UserID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
                Return -2 'There is No User With This ID
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function CountLinkCategoriesByLinkServiceID(ByVal LinkServiceID As Long) As Integer
        Dim a As New LinkCategoriesTableAdapter
        Dim b As Long = a.CountLinkCategoriesByLinkServiceID(LinkServiceID)
        Return b
    End Function
    Public Function RECDeletelinkCategoryByLinkCategoryID(ByVal LinkCategoryID As Long) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            If Link.CountLinkCategoriesByLinkCategoryID(LinkCategoryID) <> 0 Then

                Dim TableCategory As LinksDAL.LinkCategoriesDataTable = LinkCategoriesByParentID(LinkCategoryID)
                For Each Row As LinksDAL.LinkCategoriesRow In TableCategory.Rows
                    RECDeletelinkCategoryByLinkCategoryID(Row.LinkCategoryID)
                Next
                Dim DeleteID As Long = Link.RemoveLinkCategoryByLinkCategoryID(LinkCategoryID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            End If
            Return -2
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeletelinkCategoryByLinkCategoryID(ByVal LinkCategoryID As Long) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            If Link.CountLinkCategoriesByLinkCategoryID(LinkCategoryID) <> 0 Then
                Dim TableCategory As LinksDAL.LinkCategoriesDataTable = LinkCategoriesByParentID(LinkCategoryID)
                For Each Row As LinksDAL.LinkCategoriesRow In TableCategory.Rows
                    DeletelinkCategoryByLinkCategoryID(Row.LinkCategoryID)
                Next
                Dim DeleteID As Long = Link.RemoveLinkCategoryByLinkCategoryID(LinkCategoryID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            End If
            Return -2
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteCategoriesByLinkServiceID(ByVal LinkServiceID As Long) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            If Link.CountLinkCategoriesByLinkServiceID(LinkServiceID) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkCategoryByLinkServiceID(LinkServiceID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinkCategoriesByParentID(ByVal ParentID As Long) As Integer
        Try
            Dim Link As New LinkCategoriesTableAdapter()
            If Link.CountLinkCategoriesByParentID(ParentID) <> 0 Then
                Dim DeleteID As Long = Link.RemoveLinkCategoryByParentID(ParentID)
                If DeleteID <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
                Return -2
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function counterLinkCategoriesByParentIDandTitle(ByVal Title As String, ByVal ParentID As Long?) As Integer
        Try
            Dim link As New LinkCategoriesTableAdapter()
            Dim result As Integer
            If ParentID Is Nothing Then
                result = link.CountLinkCategoryByTitleParentIDNull(Title)
            Else
                result = link.CountLinkCategoriesByParentIDandTitle(Title, ParentID)
            End If

            If result = 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function CountLinkCategoriesByTitleLinkCategoryIDParentID(ByVal Title As String, ByVal LinkCategoryID As Long, ByVal ParentID As Long?) As Integer
        Try
            Dim CountResullt As Integer
            Dim Links As New LinkCategoriesTableAdapter()
            If ParentID Is Nothing Then
                CountResullt = Links.CountLinkCategoriesByTitleLinkCategoryIDParentIDNUll(Title, LinkCategoryID)
            Else
                CountResullt = Links.CountLinkCategoriesByTitleLinkCategoryIDParentID(Title, LinkCategoryID, ParentID)
            End If
            If CountResullt = 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkCategoryStatus(ByVal Status As Boolean, ByVal LinkCategoryID As Long) As Integer
        Try
            Dim link As New LinkCategoriesTableAdapter()
            Dim UpdateResult As Integer = link.ReviseLinkCategoryStatusByLinkCategoryID(Status, LinkCategoryID)
            If UpdateResult = 1 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function


    Public Function UpdateLinkCategoryByLinkCategoryID(ByVal ParentID As Long?, ByVal LinkServiceID As Long, ByVal Title As String, ByVal Description As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal LinkCategoryID As Long) As Integer
        Try
            Dim link As New LinkCategoriesTableAdapter()

            Dim CountResult As Integer = CountLinkCategoriesByTitleLinkCategoryIDParentID(Title, LinkCategoryID, ParentID)
            If CountResult = 1 Then
                Dim Update As Long = link.ReviseLinkCategoryByLinkCategoryID(If(ParentID = 0, Nothing, ParentID), LinkServiceID, Title, Description, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkCategoryID)
                If Update <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            ElseIf CountResult = -1 Then
                Return -2
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkCategoryByLinkCategoryIDwhitoutcheakDublicate(ByVal ParentID As Long?, ByVal LinkServiceID As Long, ByVal Title As String, ByVal Description As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal LinkCategoryID As Long) As Integer
        Try
            Dim link As New LinkCategoriesTableAdapter()
            If link.CountLinkCategoriesByLinkCategoryID(LinkCategoryID) <> 0 Then

                Dim Update As Long = link.ReviseLinkCategoryByLinkCategoryID(If(ParentID = 0, Nothing, ParentID), LinkServiceID, Title, Description, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkCategoryID)
                If Update <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    'Functions for Links DataTable
    Public Function CountLinksByLinkCategoryID(ByVal LinkCategoryID As Long) As Integer
        Dim Link As New LinksTableAdapter()
        Dim Result As Integer = Link.CountLinksByLinkCategoryID(LinkCategoryID)
        Return Result
    End Function
    Public Function Links() As DataTable
        Try
            Dim Link As New LinksTableAdapter()
            Return Link.RetrieveLinks()
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function LinksByLinkCategoryID(ByVal LinkCategoryID As Long) As DataTable
        Try
            Dim Link As New LinksTableAdapter()
            Return Link.RetrieveLinksByLinkCategoryID(LinkCategoryID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function

    Public Function LinksByUserID(ByVal UserID As Long) As DataTable
        Try
            Dim Link As New LinksTableAdapter()
            Return Link.RetrieveLinksByUserID(UserID)
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Public Function AddNewLink(ByVal LinkCategoryID As Long, ByVal Title As String, ByVal Description As String, ByVal URL As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal Image As Byte(), ByVal ImageType As String) As Integer
        Try
            Dim link As New LinksTableAdapter()
            If link.CountLinksByTitleLinkCategoryID(Title, LinkCategoryID) = 0 Then
                Dim Insert As Long = link.RegisterNewLink(LinkCategoryID, Title, Description, URL, If(UserID = 0, Nothing, UserID), CustomOrder, Status, Image, ImageType)
                If Insert > 999 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2 'Dublicate name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinkByLinkID(ByVal LinkID As Long) As Integer
        Try
            Dim Link As New LinksTableAdapter()
            Dim Delete As Long = Link.RemoveLinkByLinkID(LinkID)
            If Delete <> 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function DeleteLinksByUserID(ByVal UserID As Long) As Integer
        Try
            Dim Link As New LinksTableAdapter()
            Dim Delete As Long = Link.RemoveLinksByUserID(UserID)
            If Delete <> 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkByLinkID(ByVal LinkID As Long, ByVal LinkCategoryID As Long, ByVal Title As String, ByVal Description As String, ByVal URL As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean) As Integer
        Try
            Dim links As New LinksTableAdapter()
            If links.CountLinksByTitleLinkCategoryIDLinkID(Title, LinkCategoryID, LinkID) = 0 Then
                Dim Update As Long = links.ReviseLinkByLinkID(LinkCategoryID, Title, Description, URL, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkID)
                If Update <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
            Else
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkThumbImage(ByVal ThumbImage() As Byte, ByVal ThumbImageType As String, ByVal LinkID As Long) As Integer
        Try
            Dim links As New LinksTableAdapter()
            Dim UpdateResult As Integer = links.ReviseLinkThumbImageByLinkID(ThumbImage, ThumbImageType, LinkID)
            If UpdateResult = 1 Then
                Return 1
            Else
                Return -1

            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkByLinkIDandImg(ByVal LinkID As Long, ByVal LinkCategoryID As Long, ByVal Title As String, ByVal Description As String, ByVal URL As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal Image As Byte(), ByVal Type As String) As Integer
        Try
            Dim links As New LinksTableAdapter()
            If links.CountLinksByTitleLinkCategoryID(Title, LinkCategoryID) = 0 Then
                Dim Update As Long = links.ReviseLinkwithimageByLinkID(LinkCategoryID, Title, Description, URL, If(UserID = 0, Nothing, UserID), CustomOrder, Status, Image, Type, LinkID)
                If Update <> 0 Then
                    Return 1
                Else
                    Return -1
                End If
                Return -2 'Dublicate Name
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkByLinkIDandImgwithoutcheajdublicatename(ByVal LinkID As Long, ByVal LinkCategoryID As Long, ByVal Title As String, ByVal Description As String, ByVal URL As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean, ByVal Image As Byte(), ByVal Type As String) As Integer
        Try
            Dim links As New LinksTableAdapter()

            Dim Update As Long = links.ReviseLinkwithimageByLinkID(LinkCategoryID, Title, Description, URL, If(UserID = 0, Nothing, UserID), CustomOrder, Status, Image, Type, LinkID)
            If Update <> 0 Then
                Return 1
            Else
                Return -1
            End If


        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function UpdateLinkStatus(ByVal Status As Boolean, ByVal LinkID As Long) As Integer
        Try
            Dim Link As New LinksTableAdapter()
            Dim UpdateResult As Integer = Link.ReviseLinkStatusByLinkID(Status, LinkID)
            If UpdateResult = 1 Then
                Return 1
            Else
                Return -1

            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
    Public Function LinksByServiceName(ByVal ServiceName As String) As LinksDAL.LinksDataTable
        Dim LinkAdapter As New LinksTableAdapter()
        Try

            Dim Table As LinksDAL.LinksDataTable = LinkAdapter.RetrieveLinksByServiceName(ServiceName)
            Return Table
        Catch ex As Exception
            Dim TableNull As New LinksDAL.LinksDataTable()
            Return TableNull

        End Try
    End Function
    Public Function UpdateLinkByLinkIDwithOutCheakName(ByVal LinkID As Long, ByVal LinkCategoryID As Long, ByVal Title As String, ByVal Description As String, ByVal URL As String, ByVal UserID As Long?, ByVal CustomOrder As Short, ByVal Status As Boolean) As Integer
        Try
            Dim links As New LinksTableAdapter()

            Dim Update As Long = links.ReviseLinkByLinkID(LinkCategoryID, Title, Description, URL, If(UserID = 0, Nothing, UserID), CustomOrder, Status, LinkID)
            If Update <> 0 Then
                Return 1
            Else
                Return -1
            End If
        Catch ex As Exception
            Return -1000
        End Try
    End Function
End Class
